#ifndef _MAP_H_
#define _MAP_H_

#include "castle.h"
#include "army.h"

#define TYPE_PLAINS  1
#define TYPE_MIXED   2
#define TYPE_FOREST  3


#define TILE_GRASS  '{'
#define TILE_TREES  '|'
#define TILE_ROCKS  '}'
#define TILE_CASTLE '~'
#define TILE_ARMY   '^'

typedef struct MAP_POINT 
{
	int tile;
	CASTLE *castle;	
	int x, y; 

	/* A* flags */
	int is_opened, is_closed;
	struct MAP_POINT *parent;
	int f,g,h;
} MAP_POINT;

typedef struct MAP_POINT_STACK
{
	MAP_POINT *point[400];
	int size;
} MAP_POINT_STACK;

typedef struct MAP 
{
	MAP_POINT grid[19][19];
	int color[256];
	CASTLE *castles;
	struct ARMY *armies;
} MAP;

extern MAP *map;

MAP *map_create(int type);
void map_destroy(MAP *map);
void map_add_castles(MAP *map, int lord_count, int castle_count);
void map_draw(MAP *map, BITMAP *bmp, int x, int y);

int map_get_enemy(MAP *map, int x, int y, int player);
int map_get_enemy_size(MAP *map, int x, int y, int player);
void map_reduce_troops(MAP *map, int x, int y, int lord, int new_size);

MAP_POINT *map_next_step(int player, MAP_POINT *source, MAP_POINT *dest);

#endif
